/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf;

import com.ibm.hwmca.base.rsf.BaseRsfConfigData;
import com.ibm.hwmca.base.rsf.BaseRsfErrorIds;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfHandler;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequest;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestImpl;
import com.ibm.hwmca.base.rsf.sas.ChangePasswordSchedulable;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.rsf.util.FtService;
import com.ibm.hwmca.base.rsf.util.RqService;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.rbf.HandlerAlreadyRegisteredException;
import com.ibm.hwmca.fw.rbf.HandlerNotRegisteredException;
import com.ibm.hwmca.fw.rbf.RbfManager;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.RbfRequestType;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigEvent;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigListener;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RequestQueueListener;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.RsfRequestBody;
import com.ibm.hwmca.fw.util.HThreadGroup;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BaseRemoteSupportFacility
implements RemoteSupportFacility,
OutboundConfigListener,
BaseRsfErrorIds {
    private static final String TRACE_MASKT = "XRSFBIMT";
    private static final String TRACE_MASKF = "XRSFBIMF";
    private static final String TRACE_MASKD = "XRSFBIMD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "BaseRemSup");
    private static MicrocodeLogAttributes infoLog = MicrocodeLogAttributes.INFO_LOG;
    private static MicrocodeLogAttributes errorLog = MicrocodeLogAttributes.ERROR_LOG;
    private static MicrocodeLogAttributes infoLogDisplayError = new MicrocodeLogAttributes(false, false, true, true, true, true, false, 0);
    private static final String DFC_CONFIG_ID = "basersfimpl";
    private static final String HANDLER_PREFIX = "handler_";
    private static final String CONFIG_SUFFIX = ".xml";
    private static final String credential_props_filename = "credentialInfo.props";
    private static final String LEGACY_BACKUP = "CREDENTIAL_LEGACY_BACKUP";
    private static final String CONFIGURED_CREDENTIAL_RETRIES = "CREDENTIAL_RETRIES";
    private static final String DEFAULT_CUSTOMER_INFO = "DEFAULT_CUSTOMER_INFO";
    private static final String CREDENTIAL_TIMEOUT = "CREDENTIAL_TIMEOUT";
    private static final String TEST_FLAG = "TEST_FLAG";
    private static final String DEV_INFO = "DEV_INFO";
    public static boolean SE_RSF = false;
    public static boolean PI_RSF = false;
    public static boolean HMC_RSF = false;
    public static boolean TKE_RSF = false;
    private static BaseRemoteSupportFacility baseRsf = null;
    private List handlers = new ArrayList();
    private Object handlersLock = new Object();
    private BaseRsfConfigData persistentCfgData = null;
    private Object dataLock = new Object();
    private List waitingRequests = new LinkedList();
    private List activeRequests = new LinkedList();
    private boolean clearRequests = false;
    private Object queueLock = new Object();
    private List queueListeners = new ArrayList();
    private Object listenerLock = new Object();
    private static final int numEventTypes = 5;
    private static final String[] eventNames = new String[]{"addedToWaiting", "removedFromWaiting", "requestChanged", "movedFromWaitingToActive", "removedFromActive"};
    private static final int EVENT_ADDED_TO_WAITING = 0;
    private static final int EVENT_REMOVED_FROM_WAITING = 1;
    private static final int EVENT_REQUEST_CHANGED = 2;
    private static final int EVENT_MOVED_FROM_WAITING_TO_ACTIVE = 3;
    private static final int EVENT_REMOVED_FROM_ACTIVE = 4;
    private int eventSN = 0;
    private LinkedList eventQueue = new LinkedList();
    private Thread eventThread;
    private Object eventLock = new Object();
    private static final int idleTimeout = 60;
    private static final String PERSISTENCE_NAME = "com.ibm.hwmca.base.rsf.BaseRsfConfigData";
    public static final String IMPL_ID = "com.ibm.hwmca.base.rsf.BaseRsfImpl";
    public static final int REQUEST_SUBMITTED = 0;
    public static final int REQUEST_HANDLING = 1;
    public static final int REQUEST_PROCESSING_RESULT = 2;
    public static final int REQUEST_DONE = 3;
    public static final String STORAGE_TO_SDR = "ssdr";
    public static final String STORAGE_TO_IP_RETAIN = "sipap";
    public static final String STORAGE_TO_Z_RETAIN = "szpap";
    public static final String OPTICAL_DEVICE = "opap";
    public static final String Z_TO_SDR = "eserv";
    public static final String Z_TO_ZPAP = "zpap";
    public static final String Z_TO_STP = "zstp";
    public static final RbfRequestType eservZType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "eserv", 0);
    public static final RbfRequestType retainZType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "zpap", 0);
    public static final RbfRequestType retainIPType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "ipap", 0);
    public static final RbfRequestType retainSSType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "spap", 0);
    public static final RbfRequestType sdrType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "sdr", 0);
    public static final RbfRequestType retainZPIType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "zpi", 0);
    public static final RbfRequestType phoneListType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "phlist", 0);
    public static final RbfRequestType systemAuthType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "sysauth", 0);
    public static final RbfRequestType siSdrType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "ssdr", 0);
    public static final RbfRequestType siPapType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "sipap", 0);
    public static final RbfRequestType szPapType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "szpap", 0);
    public static final RbfRequestType oPapType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "opap", 0);
    public static final RbfRequestType stpType0 = new RbfRequestType("com.ibm.hwmca.base.rsf.BaseRsfImpl", "zstp", 0);
    public static final RbfRequestType baseType = retainZType0;
    public static final RbfRequestType eservType0 = eservZType0;
    public static final RbfRequestType retainType0 = retainZType0;
    public static HashMap credentialStores = new HashMap();
    public static boolean legacyBackup = false;
    public static int allowedConsecutiveCredentialFailures = 3;
    public static int consecutiveCredentialFailures = 0;
    public static String firmwareRelease = "001";
    public static boolean brokerRequests = true;
    public static String testFlag = "";
    public static String devInfo = "";
    public static String lastCredentialStoreImpl = null;
    public static boolean testRQ = false;
    public static int testWait = 10000;

    private BaseRemoteSupportFacility() {
        this.init();
        Trace.trace(TRACE_MASKT, "<> BaseRemoteSupportFacility()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Trace.trace(TRACE_MASKT, "-> init()");
        int type = 2;
        try {
            byte[] simData = SimServer.getSimServer().readSim(5);
            if (simData != null && simData.length > 0) {
                type = simData[0];
            }
        }
        catch (Exception e) {
            this.logError("BaseRemoteSupportFacility.init: Exception reading XCPX_STATUS", e, (short)12802);
        }
        if (type == 4) {
            PI_RSF = true;
        } else if (type == 5) {
            TKE_RSF = true;
        } else if (type == 1 || type == 3) {
            SE_RSF = true;
        } else {
            HMC_RSF = true;
        }
        PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
        if (persMgr.contains(PERSISTENCE_NAME)) {
            try {
                this.persistentCfgData = (BaseRsfConfigData)persMgr.read(PERSISTENCE_NAME);
                if (this.clearRequests) {
                    this.persistentCfgData.getRbfRequests().clear();
                }
            }
            catch (PersistenceException pe) {
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility.init: Exception restoring persistent data");
                this.persistentCfgData = new BaseRsfConfigData();
                this.logError("BaseRemoteSupportFacility.init: Exception reading persistent config data", pe, (short)12801);
            }
        } else {
            String desc = "Persistent data com.ibm.hwmca.base.rsf.BaseRsfConfigData unavailable";
            Trace.trace(TRACE_MASKF, desc);
            this.persistentCfgData = new BaseRsfConfigData();
            if (!PI_RSF && this.persistentCfgData.isCallHome()) {
                byte[] callHome = new byte[]{1};
                if (TKE_RSF) {
                    callHome[0] = 0;
                }
                try {
                    Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility.init: writeSim XMRC_RSF_ENABLED " + callHome[0]);
                    SimServer.getSimServer().writeSim(103, callHome);
                }
                catch (Exception e) {
                    this.logError("BaseRemoteSupportFacility.setCallHomeEnabled: Exception setting XMRC_RSF_ENABLED", e, (short)12802);
                }
            }
        }
        try {
            String configPath = BaseFileControl.getFilePath(DFC_CONFIG_ID);
            Trace.trace(TRACE_MASKF, "Base rsf config path=" + configPath);
            ConfigXmlHandler cfgHandler = new ConfigXmlHandler();
            File[] handlerFiles = new File(configPath).listFiles(new HandlerFileFilter());
            if (handlerFiles != null) {
                for (int i = 0; i < handlerFiles.length; ++i) {
                    String desc;
                    Trace.trace(TRACE_MASKF, "Handler file=" + handlerFiles[i]);
                    try {
                        HandlerData handlerData = cfgHandler.parseHandlerXML(new FileReader(handlerFiles[i]));
                        Object object = this.handlersLock;
                        synchronized (object) {
                            this.handlers.add(handlerData);
                        }
                        desc = "Successfully configured " + handlerData.handlerClassName;
                        Trace.trace(TRACE_MASKF, desc);
                        continue;
                    }
                    catch (Exception e2) {
                        desc = "Exception processing RSF configuration " + handlerFiles[i] + ":\n" + this.getStackTrace(e2);
                        Trace.trace(TRACE_MASKF, desc);
                    }
                }
            } else {
                Trace.trace(TRACE_MASKF, "No handler configuration files found");
            }
            File propsFile = new File(configPath, credential_props_filename);
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(propsFile));
                String credentialLegacyBackup = props.getProperty(LEGACY_BACKUP);
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: CREDENTIAL_LEGACY_BACKUP='" + credentialLegacyBackup + "'");
                if (credentialLegacyBackup.equalsIgnoreCase("false")) {
                    legacyBackup = false;
                } else if (credentialLegacyBackup.equalsIgnoreCase("true")) {
                    legacyBackup = true;
                } else {
                    Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: invalid value for CREDENTIAL_LEGACY_BACKUP");
                }
                String credentialRetries = props.getProperty(CONFIGURED_CREDENTIAL_RETRIES);
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: CREDENTIAL_RETRIES='" + credentialRetries + "'");
                if (credentialRetries != null) {
                    try {
                        allowedConsecutiveCredentialFailures = Integer.parseInt(credentialRetries);
                    }
                    catch (NumberFormatException e) {
                        Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: CREDENTIAL_RETRIES not an integer, default used");
                    }
                }
                String credentialTestData = props.getProperty(DEFAULT_CUSTOMER_INFO);
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: DEFAULT_CUSTOMER_INFO='" + credentialTestData + "'");
                if (credentialTestData != null) {
                    if (credentialTestData.equalsIgnoreCase("false")) {
                        CredentialUtils.credentialDataTest = false;
                    } else if (credentialTestData.equalsIgnoreCase("true")) {
                        CredentialUtils.credentialDataTest = true;
                    } else {
                        Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: invalid value for DEFAULT_CUSTOMER_INFO");
                    }
                }
                String releaseNo = props.getProperty("FIRMWARE_RELEASE_LEVEL");
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: FIRMWARE_RELEASE_LEVEL='" + releaseNo + "'");
                if (releaseNo != null) {
                    firmwareRelease = releaseNo;
                }
                String doPasswordRetry = props.getProperty("CHANGE_PASSWORD_RETRY");
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: CHANGE_PASSWORD_RETRY='" + doPasswordRetry + "'");
                if (doPasswordRetry != null) {
                    if (doPasswordRetry.equalsIgnoreCase("false")) {
                        ChangePasswordSchedulable.retryError = false;
                    } else if (doPasswordRetry.equalsIgnoreCase("true")) {
                        ChangePasswordSchedulable.retryError = true;
                    } else {
                        Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: invalid value for CHANGE_PASSWORD_RETRY");
                    }
                }
                String displayChangePassword = props.getProperty("CHANGE_PASSWORD_DISPLAYABLE");
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: CHANGE_PASSWORD_DISPLAYABLE='" + displayChangePassword + "'");
                if (displayChangePassword != null) {
                    if (displayChangePassword.equalsIgnoreCase("false")) {
                        ChangePasswordSchedulable.canDisplay = false;
                    } else if (displayChangePassword.equalsIgnoreCase("true")) {
                        ChangePasswordSchedulable.canDisplay = true;
                    } else {
                        Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: invalid value for CHANGE_PASSWORD_DISPLAYABLE");
                    }
                }
                String changePassword = props.getProperty("CHANGE_PASSWORD_FREQUENCY");
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: CHANGE_PASSWORD_FREQUENCY='" + changePassword + "'");
                if (changePassword != null) {
                    try {
                        CredentialUtils.changePasswordFrequency = Integer.parseInt(changePassword);
                    }
                    catch (NumberFormatException e) {
                        Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: CHANGE_PASSWORD_FREQUENCY not an integer, default used");
                    }
                }
                String passwordRetry = props.getProperty("CHANGE_PASSWORD_RETRY_FREQUENCY");
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: CHANGE_PASSWORD_RETRY_FREQUENCY='" + passwordRetry + "'");
                if (changePassword != null) {
                    try {
                        CredentialUtils.changePasswordRetry = Integer.parseInt(passwordRetry);
                    }
                    catch (NumberFormatException e) {
                        Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: CHANGE_PASSWORD_RETRY_FREQUENCY not an integer, default used");
                    }
                }
                String brokering = props.getProperty("BROKER_REQUESTS");
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: BROKER_REQUESTS='" + brokering + "'");
                if (brokering != null) {
                    if (brokering.equalsIgnoreCase("false")) {
                        brokerRequests = false;
                    } else if (brokering.equalsIgnoreCase("true")) {
                        brokerRequests = true;
                    } else {
                        Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: invalid value for BROKER_REQUESTS");
                    }
                }
                String noVpn = props.getProperty("INTRANET_CONNECT");
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: INTRANET_CONNECT='" + noVpn + "'");
                if (noVpn != null) {
                    if (noVpn.equalsIgnoreCase("false")) {
                        BaseRsfHandler.testPath = false;
                    } else if (noVpn.equalsIgnoreCase("true")) {
                        BaseRsfHandler.testPath = true;
                    } else {
                        Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: invalid value for INTRANET_CONNECT");
                    }
                }
                String credentialTimeoutString = props.getProperty(CREDENTIAL_TIMEOUT);
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: CREDENTIAL_TIMEOUT='" + credentialTimeoutString + "'");
                if (credentialTimeoutString != null) {
                    try {
                        CredentialUtils.credentialTimeout = Integer.parseInt(credentialTimeoutString);
                    }
                    catch (NumberFormatException e) {
                        Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: CREDENTIAL_TIMEOUT not an integer, default used");
                    }
                }
                String inputTestFlag = props.getProperty(TEST_FLAG);
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: TEST_FLAG='" + inputTestFlag + "'");
                if (inputTestFlag != null) {
                    testFlag = inputTestFlag;
                }
                String inputDevInfo = props.getProperty(DEV_INFO);
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: DEV_INFO='" + devInfo + "'");
                if (inputDevInfo != null) {
                    devInfo = inputDevInfo;
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility: exception getting credential properties, defaults used");
                Trace.trace(TRACE_MASKF, e);
            }
            credentialStores.put(eservZType0, "com.ibm.hwmca.base.rsf.sas.LocalCredentialStore");
            credentialStores.put(retainZType0, "com.ibm.hwmca.base.rsf.sas.LocalCredentialStore");
            credentialStores.put(retainIPType0, "com.ibm.hwmca.p.rsf.PICredentials");
            credentialStores.put(retainSSType0, "com.ibm.hwmca.base.rsf.sas.LocalCredentialStore");
            credentialStores.put(sdrType0, "com.ibm.hwmca.p.rsf.PICredentials");
            credentialStores.put(retainZPIType0, "com.ibm.hwmca.p.rsf.PICredentials");
            credentialStores.put(phoneListType0, "com.ibm.hwmca.base.rsf.sas.LocalCredentialStore");
            credentialStores.put(siSdrType0, "com.ibm.hwmca.p.rsf.PICredentials");
            credentialStores.put(siPapType0, "com.ibm.hwmca.p.rsf.PICredentials");
            credentialStores.put(szPapType0, "com.ibm.hwmca.p.rsf.PICredentials");
            credentialStores.put(oPapType0, "com.ibm.hwmca.base.rsf.sas.LocalCredentialStore");
            credentialStores.put(systemAuthType0, null);
            credentialStores.put(stpType0, null);
            FtService.getFtService();
            RqService.getRqService();
            OutboundConfigManager outCfgMgr = OutboundConfigManager.getOutboundConfigManager();
            outCfgMgr.addOutboundConfigListener(this);
            OutboundConfigData outCfgData = outCfgMgr.getOutboundConfig();
            this.persistentCfgData.setCallHomeServer(outCfgData.isCallHomeServer());
            if (this.persistentCfgData.isCallHomeServer()) {
                this.registerHandlers();
            }
            Trace.trace(TRACE_MASKF, this.persistentCfgData.toString());
        }
        catch (Exception e) {
            String desc = "Exception during initialization:\n" + this.getStackTrace(e);
            Trace.trace(TRACE_MASKF, desc);
        }
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public static synchronized BaseRemoteSupportFacility getBaseRsf() {
        if (baseRsf == null) {
            baseRsf = new BaseRemoteSupportFacility();
        }
        return baseRsf;
    }

    public static RemoteSupportFacility getRsf() {
        return BaseRemoteSupportFacility.getBaseRsf();
    }

    public RsfRequest newRequestInstance(RsfRequestBody body, String resultProcClassName, LocalizableText shortDesc) throws IllegalArgumentException, UnsupportedOperationException {
        Trace.trace(TRACE_MASKT, "-> newRequestInstance()");
        BaseRsfRequest request = new BaseRsfRequest(body, resultProcClassName, shortDesc);
        Trace.trace(TRACE_MASKT, "<- newRequestInstance()");
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RsfRequest getRequest(String id) {
        Trace.trace(TRACE_MASKT, "-> getRequest(" + id + ")");
        BaseRsfRequest request = null;
        RbfRequestId rbfReqId = null;
        Object object = this.dataLock;
        synchronized (object) {
            Map rbfRequests = this.persistentCfgData.getRbfRequests();
            rbfReqId = (RbfRequestId)rbfRequests.get(id);
        }
        BaseRsfRequestImpl rbfRequest = (BaseRsfRequestImpl)RbfRequest.getRequest(rbfReqId);
        if (rbfRequest != null && rbfRequest.getState() != 0 && rbfRequest.getState() != 20) {
            request = rbfRequest.getRsfRequest();
        }
        Trace.trace(TRACE_MASKT, "<- getRequest()");
        return request;
    }

    public String getImplId() {
        return IMPL_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List[] getQueuedRequests(RequestQueueListener listener) {
        Trace.trace(TRACE_MASKT, "-> getQueuedRequests()");
        String pfx = "getQueuedRequests: ";
        Object object = this.listenerLock;
        synchronized (object) {
            Object object2 = this.queueLock;
            synchronized (object2) {
                String moreMsg = "";
                List[] returnedLists = new List[2];
                List[] sourceLists = new List[2];
                String[] listName = new String[]{"Active list", "Waiting list"};
                sourceLists[0] = this.activeRequests;
                sourceLists[1] = this.waitingRequests;
                Trace.trace(TRACE_MASKD, pfx + " about to copy list");
                for (int i = 0; i < sourceLists.length; ++i) {
                    ArrayList<RsfRequest> l = new ArrayList<RsfRequest>(sourceLists[i].size());
                    Iterator iter = sourceLists[i].iterator();
                    while (iter.hasNext()) {
                        RsfRequest request = (RsfRequest)iter.next();
                        Trace.trace(TRACE_MASKD, pfx + "Request " + request.getId() + " added to " + listName[i] + ".");
                        l.add(request);
                    }
                    returnedLists[i] = l;
                }
                if (listener != null) {
                    ListenerEntry le = new ListenerEntry(listener, this.eventSN);
                    if (!this.queueListeners.contains(le)) {
                        this.queueListeners.add(le);
                        moreMsg = " and new listener " + listener.getClass().getName() + " registered";
                    } else {
                        moreMsg = " but listener " + listener.getClass().getName() + " was already registered";
                        le = (ListenerEntry)this.queueListeners.get(this.queueListeners.indexOf(le));
                        le.eventSN = this.eventSN;
                    }
                }
                Trace.trace(TRACE_MASKF, pfx + " Returning lists of requests (" + returnedLists[0].size() + " active, " + returnedLists[1].size() + " waiting) including event #" + this.eventSN + moreMsg);
                return returnedLists;
            }
        }
    }

    public List getAvailableCallHomeServers() {
        Trace.trace(TRACE_MASKT, "-> getAvailableCallHomeServers()");
        ArrayList<String> available = new ArrayList<String>();
        if (SE_RSF && !devInfo.equals("ALL_PHONE_SERVERS")) {
            Trace.trace(TRACE_MASKF, "getAvailableCallHomeServers for SE");
            String[] callHomeServers = BaseRsfRequest.getPhoneServers();
            if (callHomeServers != null) {
                for (int i = 0; i < callHomeServers.length; ++i) {
                    available.add(callHomeServers[i]);
                }
            }
            return available;
        }
        RbfManager rbfMgr = RbfManager.getRbfManager();
        Set potential = rbfMgr.getPotentialHandlers(baseType);
        Iterator servers = potential.iterator();
        while (servers.hasNext()) {
            MachineId machineId = (MachineId)servers.next();
            String name = machineId.getName();
            String ipAddr = rbfMgr.getIpAddress(machineId);
            available.add(name + "(" + ipAddr + ")");
        }
        Trace.trace(TRACE_MASKT, "<- getAvailableCallHomeServers() " + available.size());
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueListener(RequestQueueListener listener) {
        Trace.trace(TRACE_MASKT, "-> removeQueueListener()");
        Object object = this.listenerLock;
        synchronized (object) {
            ListenerEntry lekey = new ListenerEntry(listener);
            if (this.queueListeners.remove(lekey)) {
                Trace.trace(TRACE_MASKF, listener.getClass().getName() + " deregistered");
            } else {
                Trace.trace(TRACE_MASKF, listener.getClass().getName() + " was not registered");
            }
        }
        Trace.trace(TRACE_MASKT, "<- removeQueueListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallHomeServerEnabled(boolean enabled) {
        Trace.trace(TRACE_MASKT, "-> setCallHomeServerEnabled(" + enabled + ")");
        Object object = this.dataLock;
        synchronized (object) {
            if (enabled != this.persistentCfgData.isCallHomeServer()) {
                this.persistentCfgData.setCallHomeServer(enabled);
                this.persist();
                if (enabled) {
                    this.registerHandlers();
                } else {
                    this.deregisterHandlers();
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- setCallHomeServerEnabled()");
    }

    public boolean isCallHomeServerEnabled() {
        Trace.trace(TRACE_MASKT, "-> isCallHomeServerEnabled()");
        boolean enabled = this.persistentCfgData.isCallHomeServer();
        Trace.trace(TRACE_MASKT, "<- isCallHomeServerEnabled() " + enabled);
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallHomeEnabled(boolean enabled) {
        Trace.trace(TRACE_MASKT, "-> setCallHomeEnabled(" + enabled + ")");
        if (PI_RSF) {
            Object object = this.dataLock;
            synchronized (object) {
                if (enabled != this.persistentCfgData.isCallHome()) {
                    this.persistentCfgData.setCallHome(enabled);
                    this.persist();
                }
            }
        }
        byte[] callHome = new byte[]{0};
        if (enabled) {
            callHome[0] = 1;
        }
        try {
            Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility.setCallHomeEnabled: writeSim XMRC_RSF_ENABLED " + callHome[0]);
            SimServer.getSimServer().writeSim(103, callHome);
        }
        catch (Exception e) {
            this.logError("BaseRemoteSupportFacility.setCallHomeEnabled: Exception setting XMRC_RSF_ENABLED", e, (short)12802);
        }
        Trace.trace(TRACE_MASKT, "<- setCallHomeServerEnabled()");
    }

    public boolean isCallHomeEnabled() {
        Trace.trace(TRACE_MASKT, "-> isCallHomeEnabled()");
        boolean enabled = true;
        if (PI_RSF) {
            enabled = this.persistentCfgData.isCallHome();
        } else {
            try {
                byte[] callHomeData = SimServer.getSimServer().readSim(103);
                if (callHomeData != null && callHomeData.length > 0) {
                    Trace.trace(TRACE_MASKF, "BaseRemoteSupportFacility.isCallHomeEnabled XMRC_RSF_ENABLED=" + callHomeData[0]);
                    if (callHomeData[0] == 0) {
                        enabled = false;
                    }
                }
            }
            catch (Exception e) {
                this.logError("BaseRemoteSupportFacility.isCallHomeEnabled: Exception reading XMRC_RSF_ENABLED", e, (short)12802);
            }
        }
        Trace.trace(TRACE_MASKT, "<- isCallHomeEnabled() " + enabled);
        return enabled;
    }

    public boolean isCallHomeServerAvailable() {
        if (SE_RSF && !devInfo.equals("ALL_PHONE_SERVERS")) {
            String[] phoneServers = BaseRsfRequest.getPhoneServers();
            if (phoneServers == null) {
                return false;
            }
            return phoneServers.length > 0;
        }
        RbfManager rbfMgr = RbfManager.getRbfManager();
        return !rbfMgr.getPotentialHandlers(baseType).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(String requestId, RbfRequestId rbfRequestId) {
        Trace.trace(TRACE_MASKT, "-> addRequest(" + requestId + ", " + rbfRequestId + ")");
        Object object = this.dataLock;
        synchronized (object) {
            this.persistentCfgData.getRbfRequests().put(requestId, rbfRequestId);
            this.persist();
        }
        Trace.trace(TRACE_MASKT, "<- addRequest()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(String requestId) {
        Trace.trace(TRACE_MASKT, "-> removeRequest(" + requestId + ")");
        Object object = this.dataLock;
        synchronized (object) {
            this.persistentCfgData.getRbfRequests().remove(requestId);
            this.persist();
        }
        Trace.trace(TRACE_MASKT, "<- removeRequest()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestChanged(int reason, RsfRequest request) {
        Trace.trace(TRACE_MASKT, "-> requestChanged()");
        Object object = this.queueLock;
        synchronized (object) {
            if (reason == 0) {
                Trace.trace(TRACE_MASKT, "Request submitted");
                this.waitingRequests.add(request);
                this.fireEvent(new EventData(0, request, ++this.eventSN));
            } else if (reason == 1) {
                if (this.waitingRequests.contains(request)) {
                    Trace.trace(TRACE_MASKT, "Waiting request now handling");
                    this.waitingRequests.remove(request);
                    this.activeRequests.add(request);
                    this.fireEvent(new EventData(3, request, ++this.eventSN));
                } else {
                    Trace.trace(TRACE_MASKT, "Active request changed handler");
                    this.fireEvent(new EventData(2, request, ++this.eventSN));
                }
            } else if (reason == 2) {
                if (this.activeRequests.contains(request)) {
                    Trace.trace(TRACE_MASKT, "Active request processing result");
                    this.fireEvent(new EventData(2, request, ++this.eventSN));
                } else {
                    Trace.trace(TRACE_MASKT, "Waiting request processing result");
                }
            } else if (reason == 3) {
                if (this.waitingRequests.contains(request)) {
                    Trace.trace(TRACE_MASKT, "Waiting request done");
                    this.waitingRequests.remove(request);
                    this.fireEvent(new EventData(1, request, ++this.eventSN));
                } else if (this.activeRequests.contains(request)) {
                    Trace.trace(TRACE_MASKT, "Active request done");
                    this.activeRequests.remove(request);
                    this.fireEvent(new EventData(4, request, ++this.eventSN));
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- requestChanged()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(EventData data) {
        String meth = " fireEvent() ";
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.queueListeners.isEmpty()) {
                Trace.trace(TRACE_MASKD, "fireEvent #" + data.eventSN + ". No Op, no listeners currently registered");
                return;
            }
        }
        boolean startedThread = false;
        boolean nudgedThread = false;
        Object object2 = this.eventLock;
        synchronized (object2) {
            if (this.eventThread == null) {
                this.eventThread = HThreadGroup.defaultThreadGroup().createThread(new Runnable(){

                    public void run() {
                        BaseRemoteSupportFacility.this.deliverEvents();
                    }
                }, "Base Rsf Event Thread");
                this.eventThread.setDaemon(true);
                this.eventThread.start();
                startedThread = true;
            }
            this.eventQueue.add(data);
            if (this.eventQueue.size() == 1) {
                this.eventLock.notify();
                nudgedThread = true;
            }
            if (startedThread) {
                Trace.trace(TRACE_MASKD, "fireEvent #" + data.eventSN + ". Event thread started and event queued");
            } else if (nudgedThread) {
                Trace.trace(TRACE_MASKD, "fireEvent #" + data.eventSN + ". Event queued and event thread nudged");
            } else {
                Trace.trace(TRACE_MASKD, "fireEvent #" + data.eventSN + ". Event queued");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverEvents() {
        String pfx = "deliverEvents: ";
        Trace.trace(TRACE_MASKT, "-> deliverEvents()");
        while (true) {
            EventData event;
            Object object = this.eventLock;
            synchronized (object) {
                long interval;
                long waitUntil = System.currentTimeMillis() + 60000L;
                while (this.eventQueue.isEmpty() && (interval = waitUntil - System.currentTimeMillis()) > 0L) {
                    try {
                        this.eventLock.wait(interval);
                    }
                    catch (InterruptedException e) {}
                }
                if (this.eventQueue.isEmpty()) {
                    this.eventThread = null;
                    Trace.trace(TRACE_MASKT, "<-" + pfx + "Exiting due to idle timeout");
                    return;
                }
                event = (EventData)this.eventQueue.remove(0);
            }
            if (event.type < 0 || event.type >= eventNames.length) {
                Trace.trace(TRACE_MASKF, pfx + "Ignoring event with unrecognized type: " + event.type);
                continue;
            }
            object = this.listenerLock;
            synchronized (object) {
                ArrayList ll = new ArrayList(this.queueListeners);
                if (ll.isEmpty()) {
                    Trace.trace(TRACE_MASKF, pfx + "Discarding " + eventNames[event.type] + " event for request #" + event.request.getId() + " since no listeners are now registered");
                } else {
                    Trace.trace(TRACE_MASKF, pfx + "Delivering " + eventNames[event.type] + " event for request #" + event.request.getId() + " to " + ll.size() + " listener(s)");
                }
                Iterator iter = ll.iterator();
                while (iter.hasNext()) {
                    ListenerEntry le = (ListenerEntry)iter.next();
                    RequestQueueListener listener = le.listener;
                    if (event.eventSN <= le.eventSN) {
                        Trace.trace(TRACE_MASKF, pfx + "Supressing event for listener: " + listener.getClass().getName());
                        continue;
                    }
                    try {
                        Trace.trace(TRACE_MASKF, pfx + "Calling listener: " + listener.getClass().getName());
                        switch (event.type) {
                            case 0: {
                                listener.addedToWaiting(event.request);
                                break;
                            }
                            case 1: {
                                listener.removedFromWaiting(event.request);
                                break;
                            }
                            case 2: {
                                listener.activeRequestChanged(event.request);
                                break;
                            }
                            case 3: {
                                listener.moveFromWaitingToActive(event.request);
                                break;
                            }
                            case 4: {
                                listener.removedFromActive(event.request);
                            }
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, pfx + "Exception thrown by listener");
                        Trace.trace(TRACE_MASKF, e);
                    }
                }
                if (!ll.isEmpty()) {
                    Trace.trace(TRACE_MASKF, pfx + "Done delivering event");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist() {
        Trace.trace(TRACE_MASKT, "-> persist()");
        Trace.trace(TRACE_MASKF, this.persistentCfgData.toString());
        Object object = this.dataLock;
        synchronized (object) {
            try {
                PersistenceManager.getPersistenceManager().write(PERSISTENCE_NAME, this.persistentCfgData);
            }
            catch (PersistenceException pe) {
                Trace.trace(TRACE_MASKF, "Unable to persist persistent data: " + pe.getMessage());
            }
        }
        Trace.trace(TRACE_MASKT, "<- persist()");
    }

    public void outboundConfigChanged(OutboundConfigEvent event) {
        Trace.trace(TRACE_MASKT, "-> outboundConfigChanged()");
        OutboundConfigData outConfigData = event.getOutboundConfigData();
        this.setCallHomeServerEnabled(outConfigData.isCallHomeServer());
        Trace.trace(TRACE_MASKT, "<- outboundConfigChanged()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerHandlers() {
        Trace.trace(TRACE_MASKT, "-> registerHandlers()");
        RbfManager rbfMgr = RbfManager.getRbfManager();
        Object object = this.handlersLock;
        synchronized (object) {
            Iterator allHandlers = this.handlers.iterator();
            while (allHandlers.hasNext()) {
                HandlerData handlerData = (HandlerData)allHandlers.next();
                Iterator allTypes = handlerData.requestTypes.iterator();
                while (allTypes.hasNext()) {
                    RbfRequestType reqType = (RbfRequestType)allTypes.next();
                    try {
                        rbfMgr.registerHandler(handlerData.handlerClass, reqType);
                    }
                    catch (HandlerAlreadyRegisteredException hare) {}
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- registerHandlers()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterHandlers() {
        Trace.trace(TRACE_MASKT, "-> deregisterHandlers()");
        RbfManager rbfMgr = RbfManager.getRbfManager();
        Object object = this.handlersLock;
        synchronized (object) {
            Iterator allHandlers = this.handlers.iterator();
            while (allHandlers.hasNext()) {
                HandlerData handlerData = (HandlerData)allHandlers.next();
                Iterator allTypes = handlerData.requestTypes.iterator();
                while (allTypes.hasNext()) {
                    RbfRequestType reqType = (RbfRequestType)allTypes.next();
                    try {
                        rbfMgr.deregisterHandler(reqType);
                    }
                    catch (HandlerNotRegisteredException hnre) {}
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- deregisterHandlers()");
    }

    private String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        throwable.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    private void logInfo(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    private void logError(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    private class ConfigXmlHandler
    extends DefaultHandler {
        private static final String ELEMENT_BASE_RSF_HANDLER = "BaseRsfHandler";
        private static final String ELEMENT_CLASS = "Class";
        private static final String ELEMENT_REQUEST_TYPE = "RequestType";
        private static final String ELEMENT_OWNER = "Owner";
        private static final String ELEMENT_TYPE = "Type";
        private static final String ELEMENT_VERSION = "Version";
        private XMLReader xmlReader = new SAXParser();
        private StringBuffer chars = new StringBuffer();
        private HandlerData handlerData;
        private RequestTypeData reqTypeData;

        public ConfigXmlHandler() {
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setErrorHandler(this);
        }

        public synchronized HandlerData parseHandlerXML(Reader reader) throws IOException, SAXException {
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", true);
            this.xmlReader.parse(new InputSource(reader));
            return this.handlerData;
        }

        public void startDocument() throws SAXException {
            this.chars.setLength(0);
            this.handlerData = new HandlerData();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals(ELEMENT_REQUEST_TYPE)) {
                this.reqTypeData = new RequestTypeData();
            }
            this.chars.setLength(0);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals(ELEMENT_BASE_RSF_HANDLER)) {
                try {
                    this.handlerData.handlerClass = Class.forName(this.handlerData.handlerClassName);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new SAXException(cnfe);
                }
            } else if (localName.equals(ELEMENT_CLASS)) {
                this.handlerData.handlerClassName = this.chars.toString();
            } else if (localName.equals(ELEMENT_REQUEST_TYPE)) {
                RbfRequestType reqType = new RbfRequestType(this.reqTypeData.owner, this.reqTypeData.type, this.reqTypeData.version);
                this.handlerData.requestTypes.add(reqType);
            } else if (localName.equals(ELEMENT_OWNER)) {
                this.reqTypeData.owner = this.chars.toString();
            } else if (localName.equals(ELEMENT_TYPE)) {
                this.reqTypeData.type = this.chars.toString();
            } else if (localName.equals(ELEMENT_VERSION)) {
                this.reqTypeData.version = new Integer(this.chars.toString());
            }
            this.chars.setLength(0);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.chars.append(ch, start, length);
        }
    }

    private class RequestTypeData {
        String owner;
        String type;
        int version;

        private RequestTypeData() {
        }
    }

    private class HandlerData {
        String handlerClassName;
        Class handlerClass;
        List requestTypes = new ArrayList();

        private HandlerData() {
        }
    }

    private class HandlerFileFilter
    implements FilenameFilter {
        private HandlerFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(BaseRemoteSupportFacility.HANDLER_PREFIX) && name.endsWith(BaseRemoteSupportFacility.CONFIG_SUFFIX);
        }
    }

    private class EventData {
        int type;
        RsfRequest request;
        int eventSN;

        EventData(int type, RsfRequest request, int eventSN) {
            this.type = type;
            this.request = request;
            this.eventSN = eventSN;
        }
    }

    private class ListenerEntry {
        RequestQueueListener listener;
        int eventSN = 0;

        ListenerEntry(RequestQueueListener listener, int eventSN) {
            this.listener = listener;
            this.eventSN = eventSN;
        }

        ListenerEntry(RequestQueueListener listener) {
            this.listener = listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof ListenerEntry)) {
                return false;
            }
            return this.listener == ((ListenerEntry)other).listener;
        }
    }
}

